/**************************************************************************/
/* FILE NAME: common.h                        COPYRIGHT (c) MOTOROLA 2004 */
/* VERSION:  0.01                                 All Rights Reserved     */
/*                                                                        */
/* DESCRIPTION:                                                           */
/* This header file contains all constant definitions used by eQADC       */
/* Validation Code. Makes the code more readable...                       */
/*========================================================================*/
/* UPDATE HISTORY                                                         */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */
/* 0.1   Pauline Ryan 18-March-04  Initial Version                        */
/**************************************************************************/

#include "mpc5561.h"

// CFIFO Status Constants
#define IDLE 0
#define WAIT 2
#define TRIGD 3

// CFIFO Trigger Mode Constants
#define DISABLE_Q 0x0
#define SW_TRIG_SS 0x1
#define LOW_GATED_EXT_SS 0x2
#define HIGH_GATED_EXT_SS 0x3
#define FALLING_EXT_SS 0x4
#define RISING_EXT_SS 0x5			
#define FALL_OR_RISE_EXT_SS 0x6
#define SW_TRIG_CS 0x9				//Used for Phase 2 MM Test
#define LOW_GATED_EXT_CS 0xA
#define HIGH_GATED_EXT_CS 0xB
#define FALLING_EXT_CS 0xC
#define RISING_EXT_CS 0xD
#define FALL_OR_RISE_EXT_CS 0xE 

#define CFIFO0_PUSH  0xFFF80010
#define CFIFO1_PUSH  0xFFF80014
#define CFIFO5_PUSH  0xFFF80024
#define RFIFO0_POP   0xFFF80032
#define RFIFO1_POP   0xFFF80036

enum trignum {ETRIG0=0, ETRIG1=1, ETRIG2=2, ETRIG3=3, ETRIG4=4, ETRIG5=5};
enum trigtype {RES_TRIG=0, ETPUA_TRIG=1, EMIOS_TRIG=2, ETRIG_TRIG=3};

typedef int trignum; 
typedef int trigtype;

#ifndef _QUEUES_H_
#define _QUEUES_H_

vuint32_t CQUEUE0;    // CFIFO 0 Queue Variable declaration
vuint32_t CQUEUE1;    // CFIFO 1 Queue Variable declaration
vuint32_t CQUEUE5[6];    // CFIFO 5 Queue Variable declaration

vuint16_t RQUEUE0[1024];     // RFIFO 0 Queue Variable declaration
vuint16_t RQUEUE1[1024];     // RFIFO 1 Queue Variable declaration

#endif
